/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWOperationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import javax.swing.table.AbstractTableModel;

public class VWOperationTableModel
extends AbstractTableModel {
    public static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_DESCRIPTION = 1;
    private VWOperationDefinition[] m_rowData = null;

    public void reinitialize(VWOperationDefinition[] vwOperationDefs) {
        try {
            this.m_rowData = vwOperationDefs;
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWOperationDefinition getItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.length) {
            return null;
        }
        return this.m_rowData[nRowIndex];
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_description;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.length;
        }
        return 0;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWOperationDefinition vwOperationDef = this.getItemAt(nRowIndex);
            if (vwOperationDef == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return vwOperationDef.getName();
                }
                case 1: {
                    return vwOperationDef.getDescription();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

